/*
 * @(#)PertApplicationModel.java  1.0  2006-06-18
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.pert;

import ch.hslu.cm.pert.diagram.DependencyFigure;
import ch.hslu.cm.pert.diagram.PertDiagram;
import ch.hslu.cm.pert.diagram.TaskFigure;
import ch.randelshofer.html.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.View;
import ch.hslu.cm.app.action.Arrangeable;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.app.action.file.ExportFileAction;
import org.jhotdraw.app.action.view.ToggleViewPropertyAction;
import org.jhotdraw.app.action.view.ViewPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.TextAreaCreationTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * PertApplicationModel.
 * 
 * @author Werner Randelshofer.
 * @version 1.0 2006-06-18 Created.
 */
public class PertApplicationModel extends DefaultApplicationModel {
    /*private*/ final static double[] scaleFactors = {5, 4, 3, 2, 1.5, 1.25, 1, 0.75, 0.5, 0.25, 0.10};
    private static class ToolButtonListener implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;
        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }
        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == ItemEvent.SELECTED) {
                editor.setTool(tool);
            }
        }
    }
    /**
     * This editor is shared by all projects.
     */
    private DefaultDrawingEditor sharedEditor;
    
    private HashMap<String,Action> actions;
    
    /** Creates a new instance. */
    public PertApplicationModel() {
    }
    
    @Override
    public ActionMap createActionMap(Application a, View v) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.pert.Labels");
        AbstractAction aa;
        ActionMap am=super.createActionMap(a, v);
        am.put(ExportFileAction.ID, new ExportFileAction(a,v));
        am.put(ComparePertModelsAction.ID, new ComparePertModelsAction(a,v));
        am.put("toggleOptionsPanel", aa = new ToggleViewPropertyAction(a,v, "optionsVisible"));
        labels.configureAction(aa, "options");
        am.put("toggleGrid", aa = new ToggleViewPropertyAction(a,v, "gridVisible"));
        labels.configureAction(aa, "grid");
        am.put("pArrangeHorizontal", aa = new ViewPropertyAction(a,v, "arrangement", Arrangeable.Arrangement.HORIZONTAL));
        labels.configureAction(aa, "arrangeHorizontal");
        am.put("pArrangeVertical", aa = new ViewPropertyAction(a,v, "arrangement", Arrangeable.Arrangement.VERTICAL));
        labels.configureAction(aa, "arrangeVertical");
        am.put("pArrangeCascade", aa = new ViewPropertyAction(a,v, "arrangement", Arrangeable.Arrangement.CASCADE));
        labels.configureAction(aa, "arrangeOverlap");
        for (double sf : scaleFactors) {
            am.put((int) (sf*100)+"%",
                    aa = new ViewPropertyAction(a,v, "scaleFactor", Double.TYPE, new Double(sf))
                    );
            aa.putValue(Action.NAME, (int) (sf*100)+" %");
            
        }
        return am;
    }
    
    public DefaultDrawingEditor getSharedEditor() {
        if (sharedEditor == null) {
            sharedEditor = new DefaultDrawingEditor();
        }
        return sharedEditor;
    }
    
    @Override
    public void initView(Application a, View p) {
        if (a.isSharingToolsAmongViews()) {
            ((PertView) p).setDrawingEditor(getSharedEditor());
        }
    }
    private void addCreationButtonsTo(JToolBar tb, final DrawingEditor editor) {
        // AttributeKeys for the entitie sets
        HashMap<AttributeKey,Object> attributes;
        
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.pert.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        
        ButtonFactory.addSelectionToolTo(tb, editor);
        tb.addSeparator();
        
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(AttributeKeys.FILL_COLOR, PertDiagram.TASK_FILL_COLOR);
        attributes.put(AttributeKeys.STROKE_COLOR, PertDiagram.TASK_STROKE_COLOR);
        attributes.put(AttributeKeys.TEXT_COLOR, PertDiagram.TASK_TEXT_COLOR);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new TaskFigure(), attributes), "createTask", labels);

        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(AttributeKeys.FILL_COLOR, PertDiagram.DEPENDENCY_FILL_COLOR);
        attributes.put(AttributeKeys.STROKE_COLOR, PertDiagram.DEPENDENCY_STROKE_COLOR);
        attributes.put(AttributeKeys.TEXT_COLOR, PertDiagram.DEPENDENCY_TEXT_COLOR);
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(new DependencyFigure(), attributes), "createDependency", labels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new TextAreaCreationTool(new TextAreaFigure()), "createTextArea", drawLabels);
        
    }
    /**
     * Creates toolbars for the application.
     * This class always returns an empty list. Subclasses may return other
     * values.
     */
    @Override
    public List<JToolBar> createToolBars(Application a, View pr) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.pert.Labels");
        PertView p = (PertView) pr;
        
        DrawingEditor editor;
        if (p == null) {
            editor = getSharedEditor();
        } else {
            editor = p.getDrawingEditor();
        }
        
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb;
        tb = new JToolBar();
        addCreationButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("drawToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAttributesButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("attributesToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("alignmentToolBarTitle"));
        list.add(tb);
        tb = new JToolBar(labels.getString("toolBarHTML"));
        HTMLToolBarFactory.addHTMLButtonsTo(tb);
        list.add(tb);
        return list;
    }
    
    @Override
    protected MenuBuilder createMenuBuilder() {
        PertMenuBuilder mb = new PertMenuBuilder();
        mb.setSuppressIcons(true);
        return mb;
    }

    @Override
    public URIChooser createOpenChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml","xml"));
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml","xml"));
        return c;
    }
}
